#ifndef particules_h
#define particules_h

#include <GL\gl.h>
#include <GL\glu.h>

#include "Cbob.h"

#include <vector>
#include <pthread/pthread.h>

using namespace std;

//Moteur de particule
class CMoteurParticule
{
    friend void *frmMove(void *data);//Fonction thread pour grer la MAJ des particules en parallle
    
    private:
        struct Sprts//donnes sur une particules
        {
            float px,py,pz;
            float vx,vy,vz;
            unsigned int life;
        };
        
        struct CAssPartParts//donnes sur un type de particules
        {
            unsigned char colid_flags; // si on le cullface (1)   BlendSmoke(2) BlendLight(4)
            float ffrot;
            Cbob *bob;
            vector<Sprts> prts;//les particules de ce types
        };
        
        struct SCommands//la commande de particules
        {
            unsigned char partId;
            Sprts prcs;
        };
        vector<SCommands> vCmd;//comme on est en paralle durant le frameMove
        //le join va se charger d'appliquer les commandes effectues durrant le frameMove
        
        float gravity;
        
        unsigned char nbPartsMax;//Nombre de type de particule max
        CAssPartParts *tabPartz;//table des types de particules
        unsigned char nbParts;//nombre de types de particules ajouts
        
        unsigned int eTsv;//temps qui c'est coul depuis le dernier frameMove
        pthread_t frmMvThrd;//thread
        void frameMove(unsigned int elapsedTime);//MAJ
        
    public:
        CMoteurParticule();
        ~CMoteurParticule();
        
        void initMoteurParticule(unsigned char nbPartsMax);
        
        bool addNewParticule(char *name,unsigned char colid_flags,float scale,float ffrot);
        bool addNewParticule(char *name,GLuint texId,unsigned char colid_flags,float scale,float ffrot);
        bool addNewParticule(Cbob *bob,unsigned char colid_flags,float ffrot);
        bool SuppTypeParticule(unsigned char partId);
        
        //Ajoute une particule de modle partId  la position pxyz vitesse vxyz avec une dure de vie de life ms
        bool addParticule(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life);
        //PV veut dire avec une variation alatoire sur la position (d'amplitude ampP) et la vitesse (d'amplitude ampV)
        bool addParticuleAleatPV(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float ampP,float ampV);
        //Le V tout seul signifi que seul la vitesse varie alatoirement
        bool addParticuleAleatV(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float amp);
        //Le P tout seul signifi que seul la position varie alatoirement
        bool addParticuleAleatP(unsigned char partId,float px,float py,float pz,float vx,float vy,float vz,unsigned int life,float amp);
        
        void clearParts();//Supprime juste les particules.
        void clearPartType();//Supprime les modles de particules et les particules galement.
        void clear();//Supprime tout
        
        void setGravity(float gravity);
        
        void frameMoveThread(unsigned int elapsedTime);
        void frameMoveJoin();
        void render(float px);
};

void *frmMove(void *data);//Thread de MAJ

#endif
